/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;

public class GlobalDataController {
    public static GlobalDataController instance;
    private int itemGiverId = 0;

    public GlobalDataController() {
        instance = this;
        instance.load();
    }

    public int incrementItemGiverId() {
        ++this.itemGiverId;
        this.save();
        return this.itemGiverId;
    }

    private void load() {
        CustomNpcs.debugData.start(null);
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        try {
            File file = new File(saveDir, "global.dat");
            if (file.exists()) {
                this.loadData(file);
            }
        }
        catch (Exception e) {
            try {
                File file2 = new File(saveDir, "global.dat_old");
                if (file2.exists()) {
                    this.loadData(file2);
                }
            }
            catch (Exception ee) {
                LogWriter.error(ee);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    private void loadData(File file) throws Exception {
        NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
        this.itemGiverId = compound.func_74762_e("itemGiverId");
    }

    public void save() {
        CustomNpcs.debugData.start(null);
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("itemGiverId", this.itemGiverId);
            File file = new File(saveDir, "global.dat_new");
            File file2 = new File(saveDir, "global.dat_old");
            File file3 = new File(saveDir, "global.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }
}

